//LD holder v4
//[mm]
use <common.scad>
use <ccube.scad>


boltpcbx=-3;//x-coord of PCB bolt and hole
boltpcbz=-5.4;//z-coord of bolt for rendering only (bsz to adjust surface height)
boltadjx=1.8;//x-coord of adjustment bolt and hole
boltadjz=-2.7;//z-coord of bolt for rendering only (msbz to adjust surface height)
delta=0.01;//overlap extent to make sure adjacent surfaces are fully joined or cut through

bsz=-6;//z-coord of top of bottom section
bst=3;//bottom section thickness below bsz
frontx=-6;//most forward x-coord (note LD holder 3 was 26 mm total length)
backx=21;//most backward x-coord of hinge columns (except for backext)
backext=0.5;//further back extension for resin detachment from print bed
backin=0.2;//how near backx the main sections extend
dowelpinx=5.6;//front dowel pin hole x-coordinate
width=6;//general width in Y
ldht=1.5;//thickness in x of ld holding hinge extending to backx
ldhhw=2.5;//width in y of hole for wires in ld holding hinge
adjht=0.9;//thickness of adjustment hinge behind ld holding hinge and back spacers
mst=3;//middle section thickness
msz=-2;//z-coord of top of middle section under LD
msx=4.7;//x-coord of front of middle section solid block (after bridge to adj bolt)
msbz=-3.2;//z-coord of top of adjustment bolt surface of middle section
msbt=1.8;//thickness of adjustment bolt surface below msbz
msbbz=-3.8;//z-coord of top of bridge for adjustment bolt surface
msbbt=0.55;//thickness of bridge for adjustment bolt surface
msbl=4.4;//length of adjustment bolt surface centered on boltadjx
oringspace=0.66;//sets size of bottom preload block so that the height between bottom and middle sections under adjustment bolt is this value at LD 0 angle. Note actual measured space should be around 0.66 mm, giving +-0.2 mm o-ring expansion and contraction range for 1.35 degree adjustability. Combined with resin expansion, warping, and LD beam offset, this value should be determined experimentally and does not match 0.66 mm.
ust=2;//upper section thickness above widest cross-section of LD hold-down block set by ldhd# params below
ushghx=15;//upper section hot glue hole x-coord

lddiam=6;//LD diameter
ldzoff=0.5+0.16;//Z offset (>0) of LD flat section below LD cylinder center axis, added 0.215 after first attempt to make the steps lower and LD beam higher, later changed to 0.16 to make steps higher and LD beam lower
ldxoff=4;//X offset (>0) of LD front ahead of V shape contact line at ldvx (used only for rendering LD)
ldvangle=90;//[deg] internal angle of V shape contacting LD cylinder
ldvx=6.7;//where contact point of LD cylinder and V shape should be located
ldvz=0.4;//where contact point of LD cylinder and V shape should be located
ldsangles=[-2,-1,0,1,2];//[deg] angles relative to horizontal at which LD back-stop should be stepped
ldsxs=9.32;//where the back of first back-step should start, relative to ldvx
ldsdx=0.7;//width of back-step step
ldhdx=12.25;//x location of LD hold-down line
ldhdz=ldvz+4.8;//z location of LD hold-down line (bottom)
ldhdsl=2;//side length of LD hold-down block in cross-section (also sets bottom height of upper section and depth of glue fill volume above LD and depth of the bounding walls from the top for this volume)
thetaadj=3;//[deg] one way adjustment in theta (total is +- or double this) to set width of PCB bolt slot based on rotation about dowelpinx


//back-stop calculation
zzc=sin(ldvangle/2)*lddiam/2;//z offset of contact line of V on circle from axis of LD cylinder

module vshape(){
    zzd=(lddiam/2)/sin(ldvangle/2)-zzc;//Z distance from V intersection to contact point with LD cylinder
    vcw=2.2;//V cube side width
    vch=10;//V cube side hight
    translate([ldvx,0,ldvz-zzd])
    intersection(){
    union(){
        //V-block with intersection at z=0
    rotate([-ldvangle/2,0,0])rotate([0,0,45])ccube([vcw,vcw,vch],[0,0,0.5]);
    rotate([ldvangle/2,0,0])rotate([0,0,-135])ccube([vcw,vcw,vch],[0,0,0.5]);
    }
    translate([0,0,-1])ccube([vcw*2,width,vch],[0.5,0.5,0]);//cut to size
    }
}

module backstopremove(){
for(i=[1:len(ldsangles)]){
    translate([ldvx,0,ldvz])rotate([0,-ldsangles[i-1],0])translate([0+(i-1)*ldsdx,-5.1,zzc-ldzoff])cube([ldsxs,10.2,10.2]);
}
}

module placeld(angnum){
    //diode() is facing down along Z
    translate([ldvx,0,ldvz])rotate([0,-ldsangles[angnum],0])translate([-ldxoff+angnum*ldsdx,0,zzc])rotate([0,90,0])diode();
}

module backstop(){
    bsh=4.04+ldvz;//height of backstop from msz
    bsl=4.3;//length of backstop from front edge
    bsth=1.5;//thickness of backstop sides
difference(){
translate([ldvx+ldsxs-ldsdx,0,msz-delta])union(){
    translate([0,-width/2,0])ccube([bsl,bsth,bsh],[0,0,0]);//left steps
    translate([0,width/2,0])ccube([bsl,bsth,bsh],[0,1,0]);//right steps
    ccube([bsl,width,ldvz-msz-0.5],[0,0.5,0]);//edges bending support cube
}
    backstopremove();
}
}

module uppersection(){
    translate([ldhdx,0,ldhdz])rotate([0,-45,0])ccube([ldhdsl,width,ldhdsl],[0,0.5,0]); //LD hold-down cube to push down on LD
    hz=ldhdz+ldhdsl/sqrt(2);//z-coord of widest section of hold-down cube (bottom of upper section block)
    hx=ldhdx-ldhdsl/sqrt(2);//x-coord of forward-most point of upper section
    difference(){
        translate([hx,0,hz])ccube([backx-backin-hx,width,ust],[0,0.5,0]);//upper section main cube
        translate([ushghx,0,hz-delta])cylinder($fn=10,h=ust+2*delta,d1=1.7,d2=2.6);//hot glue pour hole
    }
    //hot glue hold-in cubes:
    translate([ushghx,-width/2,ldhdz])ccube([2.5,1,ldhdsl/sqrt(2)+delta],[0.5,0,0]);
    translate([ushghx,width/2,ldhdz])ccube([2.5,1,ldhdsl/sqrt(2)+delta],[0.5,1,0]);
    translate([ushghx+1.5,0,ldhdz])ccube([0.7,width-2.5,ldhdsl/sqrt(2)+delta],[0,0.5,0]);
    translate([ldhdx,0,hz+delta])ccube([1.8,width,1],[0,0.5,1]);//top staple bending support base cube
    
    translate([backx-backin,0,hz+delta])ccube([ldht-backin,width-delta,ldhdsl/sqrt(2)],[1,0.5,1]);//LD hinge columns bending support cube
}

module middleboltsection(){
    translate([boltadjx,0,msbz])
    difference(){
        ccube([msbl,width,msbt],[0.5,0.5,1]);//middle section surface under adjustment bolt
        translate([0,0,-msbt-delta])cylinder($fn=12,h=msbt+2*delta,d=2.4);//hole for adjustment bolt in middle section
        //translate([msbl/2,-width/2-delta,msbbz-msbz])rotate([0,-10,0])cube([1,width+2*delta,msbt+delta]);//angle for resin drainage
    }
    translate([boltadjx+msbl/2-delta,0,msbbz])ccube([msx-(boltadjx+msbl/2)+delta*2,width,msbbt],[0,0.5,1]);//middle section bridge to adjustment bolt
}

module middlesection(){
    translate([0,0,0.06])vshape();//added 0.06mm vertical shift after v 20250405 was aimed slightly low and almost touching support cube - I assume due to insufficient resin curing on the angled surfaces
    backstop();
        
    translate([msx,0,msz])ccube([backx-backin-msx,width,mst],[0,0.5,1]);//middle section back main cube
    translate([ldvx,0,msz-delta])ccube([3.2,width,0.75+ldvz],[0.5,0.5,0]);//V-shape vertical support cube
    translate([backx-backin,0,msz-delta])ccube([ldht-backin,width-delta,ldvz-msz],[1,0.5,0]);//LD hinge columns bending support cube
    translate([ldvx+ldsxs-ldsdx+delta,0,msz-delta])ccube([8,width,1],[1,0.5,0]);//bottom staple bending support base cube
    translate([ldvx+ldsxs-ldsdx+delta,width/2,msz-delta])ccube([3.9,0.6,2],[1,1,0]);//bottom staple bending support wall cube right
    translate([ldvx+ldsxs-ldsdx+delta,-width/2,msz-delta])ccube([3.9,0.6,2],[1,0,0]);//bottom staple bending support wall cube left
      
    
    middleboltsection();
}

module staplecutout(){
    //location:
    stx=18.7;//staple inner edge x
    stz=8.5;//staple inner upper edge z
    stin=0.2;//staple distance in from holder outer surface
    //staple size:
    stih=11.6;//staple target internal vertical height (11.6 mm in LD Holder 3)
    stit=0.8;//removal thickness
    stiw=0.6;//removal width
    stil=6.4;//removal length after internal thickness (extra for resin drainage)
    translate([stx,-width/2-delta,stz+delta+stit])ccube([stit,stiw+stin+delta,stih+2*stit-2*delta],[0,0,1]);//vertical section to outside
    translate([stx+stit,-width/2+stin,stz])ccube([stil+stit,stiw,stit],[1,0,0]);//upper horizontal section inside
    //translate([stx+stit,-width/2+stin,stz-stih])ccube([stil+stit,stiw,stit],[1,0,1]);//lower horizontal section inside
    translate([stx+stit,-width/2-delta,stz-stih])ccube([stil+stit,stiw+stin+delta,stit],[1,0,1]);//lower horizontal section to outside
    
}

module bottomsection(){
    difference(){
        union(){
            translate([frontx,0,bsz])ccube([backx-ldht-frontx,width,bst],[0,0.5,1]);//bottom section back main cube
            translate([boltadjx,0,bsz-bst])cylinder($fn=6,h=bst,d=8);//'wings' around nut insert
            translate([dowelpinx,0,bsz-bst])cylinder($fn=6,h=bst,d=8);//'wings' around dowel pin hole
            translate([boltadjx-2.25,0,msbz-msbt-oringspace])ccube([4.9,5,bst/2],[0,0.5,1]);//o-ring bottom thickness preload
        }
        translate([boltadjx,0,bsz-bst-delta])cylinder($fn=12,h=bst*2+2*delta,d=2.4);//adj hole cutout
        //translate([boltpcbx,0,bsz-bst-delta])cylinder($fn=12,h=bst+2*delta,d=2.2);//pcb hole cutout
        //Holder to PCB mount slot
        hpd=(dowelpinx-boltpcbx)*tan(thetaadj);
        for(a=[-hpd,0,hpd]){
            translate([boltpcbx,a,bsz-bst-delta])rotate([0,0,90])cylinder($fn=10,h=bst+2*delta,d=2.5);
        }
        translate([boltpcbx-0.35,0,bsz-bst-delta])cylinder($fn=6,h=bst+2*delta,d1=2,d2=2.5);//drainage indent for PCB mount slot
        
        //Dowel pin locating hole:
        translate([dowelpinx,0,bsz-bst-delta])cylinder($fn=10,h=bst-0.5,d=1);//nominal 1mm hole
        translate([dowelpinx,0,bsz-bst+0.7])cylinder($fn=10,h=bst-1.9,d=1.4);//internal 1.4mm bore for easier dowel pin insertion
        translate([dowelpinx,0,bsz-bst-delta])ccube([2.5,0.5,bst-0.5],[0.6,0.5,0]);//cutout cube for resin drainage from dowel pin hole
        
        //LD Adjusting Nut hole:
        translate([boltadjx,0,bsz-bst-delta])union(){      
          cylinder($fn=6,h=1.9,d=4.9);//nut hole
          translate([-1.4,0,0])cylinder($fn=6,h=1.9,d1=2.8,d2=2);//nut hole resin drainage indent
        }
        
        //front corner cuts:
        fca=65;//[deg] cut angle
        fcd=1.4;//cut depth
        translate([frontx,width/2,bsz-bst-delta])rotate([0,0,-fca])translate([fcd,0,0])ccube([fcd*2,width,bst*2],[1,0.5,0]);
        translate([frontx,-width/2,bsz-bst-delta])rotate([0,0,fca])translate([fcd,0,0])ccube([fcd*2,width,bst*2],[1,0.5,0]);
        
        //PCB bolt washer indent
        //translate([boltpcbx,0,bsz-delta])m2washer();
    }
}

module hinges(){
    translate([backx,-width/2,msz-mst])ccube([ldht+delta,(width-ldhhw)/2,ldhdz+ldhdsl/sqrt(2)+ust-msz+mst],[1,0,0]);//ld hinge column left
    translate([backx-delta,-width/2+0.5,msz-mst])ccube([backext+delta,0.5,ldhdz+ldhdsl/sqrt(2)+ust-msz+mst],[0,0,0]);//column left extending section for resin detachment
    translate([backx-delta-1.4,-width/2+0.5,-1+ldhdz+ldhdsl/sqrt(2)+ust])
    difference(){//column left removal aiding corner
        ccube([backext+delta+1.4,0.5,2],[0,0,0]);
        translate([backext+delta-0,0.5,2.4])rotate([0,45,0])ccube([100,100,100],[0,0.5,0]);
    }
    translate([backx,width/2,msz-mst])ccube([ldht+delta,(width-ldhhw)/2,ldhdz+ldhdsl/sqrt(2)+ust-msz+mst],[1,1,0]);//ld hinge column right
    translate([backx-delta,width/2-0.5,msz-mst])ccube([backext+delta,0.5,ldhdz+ldhdsl/sqrt(2)+ust-msz+mst],[0,1,0]);//column right extending section for resin detachment
    translate([backx-delta-1.4,width/2-0.5,-1+ldhdz+ldhdsl/sqrt(2)+ust])
    difference(){//column right removal aiding corner
        ccube([backext+delta+1.4,0.5,2],[0,1,0]);
        translate([backext+delta-0,0.5,2.4])rotate([0,45,0])ccube([100,100,100],[0,0.5,0]);
    }
    translate([backx-ldht,0,bsz-delta])ccube([adjht,width,msz-mst-bsz+delta*2],[1,0.5,0]);//adj hinge
    difference(){
        union(){
    translate([backx-ldht-delta,-0.5,bsz-bst])ccube([ldht+delta+backext,0.7,bst],[0,1,0]);//btm back pin left
    //translate([backx-ldht-delta+1,-0.5,bsz-bst])ccube([ldht+delta+backext-1,0.7,bst+2],[0,1,0]);//btm back pin left attachment to top to avoid breakage
    translate([backx-ldht-delta,0.5,bsz-bst])ccube([ldht+delta+backext,0.7,bst],[0,0,0]);//btm back pin right
    //translate([backx-ldht-delta+1,0.5,bsz-bst])ccube([ldht+delta+backext-1,0.7,bst+2],[0,0,0]);//btm back pin left attachment to top to avoid breakage
        }
        translate([backext+delta+14,0,2.4-1.8])rotate([0,45,0])ccube([100,100,100],[0,0.5,0]);//top chamfer for easier removal
        translate([backext+delta+14,0,-29.5])rotate([0,-45,0])ccube([100,100,10],[0,0.5,0]);//bottom chamfer for easier removal and flat attachment surface
    }
}

module bolts(){
    translate([boltadjx,0,boltadjz])rotate([180,0,0])m2bolt(6);
    translate([boltpcbx,0,boltpcbz])rotate([180,0,0])m2bolt(8);
    translate([boltpcbx,0,bsz])m2washer();
    translate([boltadjx,0,boltadjz-0.5])m2washer();
    translate([boltadjx,0,bsz+0.75])oring();
}

module curingholes(){//holes added to speed up curing and reduce warping of resin
    holed=2.5;
    for(a=[0:4:10]){
        translate([9+a,0,-10])rotate([0,0,15])cylinder($fn=12,d=holed,h=4.5);
    }
    translate([6.7,0,-5.5])rotate([0,0,15])cylinder($fn=12,d=holed,h=8);
    translate([10,0,-5.5])rotate([0,0,15])cylinder($fn=12,d=holed,h=8);
    translate([13.5,0,-5.5])rotate([0,0,15])cylinder($fn=12,d=holed,h=8);
    translate([17,0,-5.5])rotate([0,0,15])cylinder($fn=12,d=holed,h=8);
    
}

module ldholder4(){
    difference(){
        union(){
            bottomsection();
            middlesection();
            uppersection();
            hinges();
        }
        staplecutout();
        mirror([0,1,0])staplecutout();
        curingholes();
    }
    //bolts();
    //placeld(1);
}

module ldholderasm(){
    translate([-boltpcbx,0,-(bsz-bst)]){
        ldholder4();
    }
}

ldholder4();
echo(ldvz+zzc);


//translate([-(ldvx-ldxoff),0,0])ldholder4();
/*tldd=165-(ldvx-ldxoff);
tldd2=192-(ldvx-ldxoff);
translate([-165,0,0])rotate([0,0,360/128-0.1])translate([tldd,0,0])ldholder4();
translate([-165,0,0])rotate([0,0,360/256+0])translate([tldd2,0,0])ldholder4();
translate([-165,0,0])rotate([0,0,-360/256+0])translate([tldd2,0,0])ldholder4();
translate([41,0,-10])m25bolt(10);*/